//
//  MCMainWindowRegistry.h
//  MCApplication
//
//  Created by Ali Lalani on 8/17/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCMainWindowRegistry : NSObject {
	@private
	
	NSMutableDictionary *_mainViews;
	NSMutableDictionary *_stackViewPanes;
	NSMutableDictionary *_stackPaneTabs;
	NSMutableDictionary *_linkListViews;


	NSMutableArray      *_tableColumnGroups;
}

+ (MCMainWindowRegistry *)defaultRegistry;

// Registration methods
- (void)registerMainViews:(NSDictionary *)mainViewConfigs;
- (void)registerStackViewPanes:(NSDictionary *)paneConfigs;
- (void)registerStackPaneTabs:(NSDictionary *)tabConfigs;
- (void)registerLinkListViews:(NSDictionary *)linkListConfigs;

- (void)registerMainView:(NSDictionary *)aMainViewConfig forIdentifier:(NSString *)anIdentifier;
- (void)registerStackViewPane:(NSDictionary *)aPaneConfig forIdentifier:(NSString *)anIdentifier;
- (void)registerStackPaneTab:(NSDictionary *)aTabConfig forIdentifier:(NSString *)anIdentifier;
- (void)registerLinkListView:(NSDictionary *)aConfig forIdentifier:(NSString *)anIdentifier;

// Lookup methods
- (NSDictionary *)mainViewForIdentifier:(NSString *)anIdentifier;
- (NSDictionary *)stackViewPaneForIdentifier:(NSString *)anIdentifier;
- (NSDictionary *)stackPaneTabForIdentifier:(NSString *)anIdentifier;
- (NSDictionary *)linkListViewForIdentifier:(NSString *)anIdentifier;

// Accessors 
- (NSMutableDictionary *)mainViews;
- (void)setMainViews:(NSMutableDictionary *)aDict;

- (NSMutableDictionary *)stackViewPanes;
- (void)setStackViewPanes:(NSMutableDictionary *)aDict;

- (NSMutableDictionary *)stackPaneTabs;
- (void)setStackPaneTabs:(NSMutableDictionary *)aDict;

- (NSMutableDictionary *)linkListViews;
- (void)setLinkListViews:(NSMutableDictionary *)aDict;

//// TABLEVIEW STUFF, TRANSPLANT INTO MAIN REGISTRY //
#pragma mark Tableview
- (void)registerTableColumnGroups:(NSArray *)array;
- (void)registerTableColumnGroup:(NSDictionary *)dict;
- (NSDictionary *)tableColumnGroupForIdentifier:(NSString *)anIdentifier;
- (NSMutableArray *)tableColumnGroups;
- (void)setTableColumnGroups:(NSMutableArray *)array;

- (NSDictionary *)tableColumnSubsetForGroup:(NSString *)aGroupIdentifier identifier:(NSString *)identifier;
@end
